<?php

namespace App\Http\Controllers;

use App\Models\Formula;
use App\Models\ProductType;
use Illuminate\Http\Request;

class FormulaController extends Controller
{
    public function index()
    {
        $formulas = Formula::with('productType')->orderBy('product_type_id')->orderBy('order')->get();
        $productTypes = ProductType::all();
        return view('formulas.index', compact('formulas', 'productTypes'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'product_type_id' => 'required|exists:product_types,id',
            'name' => 'required|string|max:255',
            'variable_name' => 'required|string|max:50',
            'formula' => 'required|string',
            'unit' => 'required|string|max:20',
            'order' => 'integer'
        ]);

        Formula::create($request->all());

        return redirect()->route('formulas.index')
            ->with('success', 'تم إضافة المعادلة بنجاح');
    }

    public function update(Request $request, Formula $formula)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'formula' => 'required|string',
            'unit' => 'required|string|max:20',
            'order' => 'integer',
            'is_active' => 'boolean'
        ]);

        $formula->update($request->all());

        return redirect()->route('formulas.index')
            ->with('success', 'تم تحديث المعادلة بنجاح');
    }

    public function destroy(Formula $formula)
    {
        $formula->delete();
        return redirect()->route('formulas.index')
            ->with('success', 'تم حذف المعادلة بنجاح');
    }

    public function getByProductType($productTypeId)
    {
        $formulas = Formula::where('product_type_id', $productTypeId)
            ->where('is_active', true)
            ->orderBy('order')
            ->get();

        return response()->json($formulas);
    }
}
