<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductType extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'code',
        'description',
        'default_variables'
    ];

    protected $casts = [
        'default_variables' => 'array'
    ];

    public function formulas()
    {
        return $this->hasMany(Formula::class);
    }

    public function calculations()
    {
        return $this->hasMany(Calculation::class);
    }
}
