<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ProductType;
use App\Models\Formula;

class DatabaseSeeder extends Seeder
{
    public function run()
    {
        // أنواع المنتجات
        $productTypes = [
            [
                'name' => 'نافذة',
                'code' => 'window',
                'description' => 'نافذة ألمنيوم قياسية',
                'default_variables' => json_encode(['الطول', 'العرض', 'السماكة'])
            ],
            [
                'name' => 'باب',
                'code' => 'door',
                'description' => 'باب ألمنيوم',
                'default_variables' => json_encode(['الطول', 'العرض', 'السماكة'])
            ],
            [
                'name' => 'شباك',
                'code' => 'small_window',
                'description' => 'شباك صغير',
                'default_variables' => json_encode(['الطول', 'العرض', 'السماكة'])
            ]
        ];

        foreach ($productTypes as $type) {
            $productType = ProductType::create($type);

            // إضافة معادلات لكل نوع منتج
            $this->addFormulasForProductType($productType->id);
        }
    }

    private function addFormulasForProductType($productTypeId)
    {
        $formulas = [
            [
                'name' => 'حلق علوي',
                'variable_name' => 'upper_frame',
                'formula' => '{العرض} - {السماكة} * 2',
                'unit' => 'mm',
                'order' => 1
            ],
            [
                'name' => 'حلق سفلي',
                'variable_name' => 'lower_frame',
                'formula' => '{العرض} - {السماكة} * 2',
                'unit' => 'mm',
                'order' => 2
            ],
            [
                'name' => 'حلق جانبي أيمن',
                'variable_name' => 'right_frame',
                'formula' => '{الطول} - {السماكة} * 2',
                'unit' => 'mm',
                'order' => 3
            ],
            [
                'name' => 'حلق جانبي أيسر',
                'variable_name' => 'left_frame',
                'formula' => '{الطول} - {السماكة} * 2',
                'unit' => 'mm',
                'order' => 4
            ],
            [
                'name' => 'المحيط الكلي',
                'variable_name' => 'total_perimeter',
                'formula' => '({الطول} + {العرض}) * 2',
                'unit' => 'mm',
                'order' => 5
            ],
            [
                'name' => 'المساحة',
                'variable_name' => 'area',
                'formula' => '{الطول} * {العرض}',
                'unit' => 'mm²',
                'order' => 6
            ]
        ];

        foreach ($formulas as $formula) {
            Formula::create(array_merge($formula, [
                'product_type_id' => $productTypeId,
                'is_active' => true
            ]));
        }
    }
}
