<!-- resources/views/calculations/show.blade.php -->
@extends('layouts.app')

@section('title', 'تفاصيل الحساب')

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('calculations.index') }}">الحسابات</a></li>
                        <li class="breadcrumb-item active" aria-current="page">تفاصيل الحساب</li>
                    </ol>
                </nav>

                <h2 class="mb-4">تفاصيل الحساب</h2>
            </div>
        </div>

        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">النتائج المحسوبة</h5>
                        <span class="badge bg-primary">{{ $calculation->productType->name }}</span>
                    </div>
                    <div class="card-body">
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <h6>معلومات الحساب:</h6>
                                <p><strong>العنوان:</strong> {{ $calculation->title }}</p>
                                <p><strong>التاريخ:</strong> {{ $calculation->created_at->format('Y-m-d H:i') }}</p>
                            </div>
                            <div class="col-md-6">
                                @if ($calculation->notes)
                                    <h6>ملاحظات:</h6>
                                    <div class="alert alert-info">
                                        {{ $calculation->notes }}
                                    </div>
                                @endif
                            </div>
                        </div>

                        <h6 class="mb-3">المتغيرات المدخلة:</h6>
                        <div class="row mb-4">
                            {{-- التعديل هنا: لا تستخدم json_decode لأن $calculation->input_variables هي بالفعل مصفوفة --}}
                            @foreach ($calculation->input_variables as $key => $value)
                                <div class="col-md-3 col-sm-4 mb-2">
                                    <div class="card border-primary">
                                        <div class="card-body text-center">
                                            <h6 class="card-title">{{ $key }}</h6>
                                            <h4 class="text-primary">{{ $value }}</h4>
                                            <small class="text-muted">mm</small>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        <h6 class="mb-3">النتائج المحسوبة:</h6>
                        <div class="row">
                            {{-- التعديل هنا أيضًا: $calculation->calculated_results هي بالفعل مصفوفة --}}
                            @foreach ($calculation->calculated_results as $key => $result)
                                <div class="col-md-4 col-sm-6 mb-3">
                                    <div class="card border-success">
                                        <div class="card-body">
                                            <h6 class="card-title">{{ $result['name'] }}</h6>
                                            <h4 class="text-success">{{ $result['value'] }} {{ $result['unit'] }}</h4>
                                            <small class="text-muted">
                                                <code>{{ $result['formula'] }}</code>
                                            </small>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <!-- خيارات الحساب -->
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">خيارات الحساب</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <a href="{{ route('calculations.create') }}?duplicate={{ $calculation->id }}"
                                class="btn btn-primary">
                                <i class="bi bi-copy"></i> نسخ الحساب
                            </a>

                            <button class="btn btn-success" onclick="printCalculation()">
                                <i class="bi bi-printer"></i> طباعة النتائج
                            </button>

                            <a href="javascript:void(0)" class="btn btn-info" onclick="shareCalculation()">
                                <i class="bi bi-share"></i> مشاركة النتائج
                            </a>
                        </div>

                        <!-- ملخص الحساب -->
                        <div class="mt-4">
                            <h6>ملخص الحساب:</h6>
                            <ul class="list-group list-group-flush">
                                <li class="list-group-item d-flex justify-content-between">
                                    <span>عدد المتغيرات:</span>
                                    <span class="badge bg-primary">{{ count($calculation->input_variables) }}</span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between">
                                    <span>عدد النتائج:</span>
                                    <span class="badge bg-success">{{ count($calculation->calculated_results) }}</span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between">
                                    <span>نوع المنتج:</span>
                                    <span>{{ $calculation->productType->name }}</span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between">
                                    <span>تاريخ الإنشاء:</span>
                                    <span>{{ $calculation->created_at->format('Y-m-d') }}</span>
                                </li>
                            </ul>
                        </div>

                        <!-- إجراءات إدارية -->
                        <div class="mt-4">
                            <h6>إجراءات إدارية:</h6>
                            <div class="d-grid gap-2">
                                <form action="{{ route('calculations.destroy', $calculation->id) }}" method="POST"
                                    onsubmit="return confirm('هل أنت متأكد من حذف هذا الحساب؟')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger w-100">
                                        <i class="bi bi-trash"></i> حذف الحساب
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- معادلات مستخدمة -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">المعادلات المستخدمة</h5>
                    </div>
                    <div class="card-body">
                        @foreach ($calculation->calculated_results as $result)
                            <div class="alert alert-light mb-2">
                                <small><strong>{{ $result['name'] }}:</strong></small>
                                <br>
                                <small><code class="text-dark">{{ $result['formula'] }}</code></small>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>

        <!-- نموذج نسخ الحساب -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">إنشاء حساب مشابه</h5>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('calculations.store') }}" method="POST">
                            @csrf
                            <input type="hidden" name="duplicate_id" value="{{ $calculation->id }}">

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="new_title" class="form-label">عنوان جديد</label>
                                        <input type="text" class="form-control" id="new_title" name="title"
                                            value="نسخة من {{ $calculation->title }}" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="new_notes" class="form-label">ملاحظات جديدة</label>
                                        <textarea class="form-control" id="new_notes" name="notes" rows="1"></textarea>
                                    </div>
                                </div>
                            </div>

                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary">
                                    <i class="bi bi-files"></i> إنشاء نسخة جديدة
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- منطقة الطباعة -->
    <div id="printArea" style="display: none;">
        <div style="padding: 20px; font-family: Arial, sans-serif;">
            <h2 style="text-align: center; color: #2c3e50;">تقرير حساب الألمنيوم</h2>
            <hr>

            <h4>معلومات الحساب:</h4>
            <p><strong>العنوان:</strong> {{ $calculation->title }}</p>
            <p><strong>نوع المنتج:</strong> {{ $calculation->productType->name }}</p>
            <p><strong>التاريخ:</strong> {{ $calculation->created_at->format('Y-m-d H:i') }}</p>

            @if ($calculation->notes)
                <p><strong>ملاحظات:</strong> {{ $calculation->notes }}</p>
            @endif

            <hr>

            <h4>المتغيرات المدخلة:</h4>
            <table style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
                <tr style="background-color: #f8f9fa;">
                    <th style="border: 1px solid #ddd; padding: 8px;">المتغير</th>
                    <th style="border: 1px solid #ddd; padding: 8px;">القيمة</th>
                    <th style="border: 1px solid #ddd; padding: 8px;">الوحدة</th>
                </tr>
                @foreach ($calculation->input_variables as $key => $value)
                    <tr>
                        <td style="border: 1px solid #ddd; padding: 8px;">{{ $key }}</td>
                        <td style="border: 1px solid #ddd; padding: 8px;">{{ $value }}</td>
                        <td style="border: 1px solid #ddd; padding: 8px;">mm</td>
                    </tr>
                @endforeach
            </table>

            <h4>النتائج المحسوبة:</h4>
            <table style="width: 100%; border-collapse: collapse;">
                <tr style="background-color: #f8f9fa;">
                    <th style="border: 1px solid #ddd; padding: 8px;">المعيار</th>
                    <th style="border: 1px solid #ddd; padding: 8px;">النتيجة</th>
                    <th style="border: 1px solid #ddd; padding: 8px;">الوحدة</th>
                    <th style="border: 1px solid #ddd; padding: 8px;">المعادلة</th>
                </tr>
                @foreach ($calculation->calculated_results as $key => $result)
                    <tr>
                        <td style="border: 1px solid #ddd; padding: 8px;">{{ $result['name'] }}</td>
                        <td style="border: 1px solid #ddd; padding: 8px;">{{ $result['value'] }}</td>
                        <td style="border: 1px solid #ddd; padding: 8px;">{{ $result['unit'] }}</td>
                        <td style="border: 1px solid #ddd; padding: 8px;"><code>{{ $result['formula'] }}</code></td>
                    </tr>
                @endforeach
            </table>

            <hr>
            <p style="text-align: center; color: #666; margin-top: 30px;">
                تم إنشاء هذا التقرير بواسطة نظام حساب الألمنيوم - {{ date('Y-m-d H:i') }}
            </p>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        function printCalculation() {
            const printContent = document.getElementById('printArea').innerHTML;
            const originalContent = document.body.innerHTML;

            document.body.innerHTML = printContent;
            window.print();
            document.body.innerHTML = originalContent;
            location.reload();
        }

        function shareCalculation() {
            if (navigator.share) {
                navigator.share({
                    title: 'حساب الألمنيوم: {{ $calculation->title }}',
                    text: 'تفاصيل حساب الألمنيوم من نظام إدارة المعمل',
                    url: window.location.href
                });
            } else {
                // نسخ الرابط إلى الحافظة
                navigator.clipboard.writeText(window.location.href).then(() => {
                    alert('تم نسخ رابط الحساب إلى الحافظة');
                });
            }
        }
    </script>
@endpush
