<!-- resources/views/dashboard.blade.php -->
@extends('layouts.app')

@section('title', 'لوحة التحكم')

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <h2 class="mb-4">لوحة التحكم - نظام حساب الألمنيوم</h2>
            </div>
        </div>

        <div class="row">
            <!-- إحصائيات -->
            <div class="col-md-3 col-sm-6 mb-4">
                <div class="card text-white bg-primary">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="card-title mb-0">إجمالي الحسابات</h6>
                                <h2 class="mb-0">{{ $totalCalculations }}</h2>
                            </div>
                            <div>
                                <i class="bi bi-calculator fs-1"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3 col-sm-6 mb-4">
                <div class="card text-white bg-success">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="card-title mb-0">أنواع المنتجات</h6>
                                <h2 class="mb-0">{{ $productTypesCount }}</h2>
                            </div>
                            <div>
                                <i class="bi bi-box fs-1"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3 col-sm-6 mb-4">
                <div class="card text-white bg-warning">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="card-title mb-0">المعادلات النشطة</h6>
                                <h2 class="mb-0">{{ $activeFormulas }}</h2>
                            </div>
                            <div>
                                <i class="bi bi-sliders fs-1"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3 col-sm-6 mb-4">
                <div class="card text-white bg-info">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="card-title mb-0">الحسابات اليوم</h6>
                                <h2 class="mb-0">{{ $todayCalculations }}</h2>
                            </div>
                            <div>
                                <i class="bi bi-calendar-day fs-1"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- الحسابات الأخيرة -->
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">آخر الحسابات</h5>
                    </div>
                    <div class="card-body">
                        @if ($recentCalculations->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>العنوان</th>
                                            <th>النوع</th>
                                            <th>التاريخ</th>
                                            <th>الإجراءات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($recentCalculations as $calculation)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td>{{ $calculation->title }}</td>
                                                <td>{{ $calculation->productType->name }}</td>
                                                <td>{{ $calculation->created_at->format('Y-m-d H:i') }}</td>
                                                <td>
                                                    <a href="{{ route('calculations.show', $calculation->id) }}"
                                                        class="btn btn-sm btn-info">
                                                        <i class="bi bi-eye"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <div class="alert alert-info">
                                لا توجد حسابات سابقة.
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- إجراءات سريعة -->
            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">إجراءات سريعة</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <a href="{{ route('calculations.create') }}" class="btn btn-primary">
                                <i class="bi bi-calculator"></i> حساب جديد
                            </a>
                            <a href="{{ route('formulas.index') }}" class="btn btn-outline-primary">
                                <i class="bi bi-sliders"></i> إدارة المعادلات
                            </a>
                            <a href="{{ route('product-types.index') }}" class="btn btn-outline-success">
                                <i class="bi bi-box"></i> أنواع المنتجات
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
