@extends('layouts.app')

@section('title', 'التقارير والإحصائيات')

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <h2 class="mb-4">التقارير والإحصائيات</h2>
            </div>
        </div>

        <!-- مرشحات التقارير -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">مرشحات التقارير</h5>
                    </div>
                    <div class="card-body">
                        <form id="reportFilters" class="row g-3">
                            <div class="col-md-3">
                                <label for="date_from" class="form-label">من تاريخ</label>
                                <input type="date" class="form-control" id="date_from" name="date_from">
                            </div>
                            <div class="col-md-3">
                                <label for="date_to" class="form-label">إلى تاريخ</label>
                                <input type="date" class="form-control" id="date_to" name="date_to">
                            </div>
                            <div class="col-md-3">
                                <label for="product_type" class="form-label">نوع المنتج</label>
                                <select class="form-select" id="product_type" name="product_type">
                                    <option value="">كل الأنواع</option>
                                    @foreach ($productTypes as $type)
                                        <option value="{{ $type->id }}">{{ $type->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 d-flex align-items-end">
                                <button type="button" class="btn btn-primary w-100" onclick="filterReports()">
                                    <i class="bi bi-filter"></i> تصفية
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- إحصائيات عامة -->
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="card bg-primary text-white">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="card-title mb-0">إجمالي الحسابات</h6>
                                <h2 class="mb-0" id="totalCalculations">{{ $stats['total_calculations'] }}</h2>
                            </div>
                            <div>
                                <i class="bi bi-calculator fs-1"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6 mb-4">
                <div class="card bg-success text-white">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="card-title mb-0">متوسط الحسابات/يوم</h6>
                                <h2 class="mb-0" id="avgPerDay">{{ number_format($stats['avg_per_day'], 1) }}</h2>
                            </div>
                            <div>
                                <i class="bi bi-calendar-check fs-1"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6 mb-4">
                <div class="card bg-warning text-white">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="card-title mb-0">أكثر نوع استخداماً</h6>
                                <h5 class="mb-0" id="mostUsedType">{{ $stats['most_used_type'] ?? 'N/A' }}</h5>
                            </div>
                            <div>
                                <i class="bi bi-star fs-1"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6 mb-4">
                <div class="card bg-info text-white">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="card-title mb-0">الحسابات هذا الشهر</h6>
                                <h2 class="mb-0" id="monthCalculations">{{ $stats['this_month'] }}</h2>
                            </div>
                            <div>
                                <i class="bi bi-calendar-month fs-1"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- مخطط توزيع الحسابات -->
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">توزيع الحسابات حسب نوع المنتج</h5>
                    </div>
                    <div class="card-body">
                        <div class="chart-container" style="height: 300px;">
                            <canvas id="productTypeChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>

            <!-- توزيع شهري -->
            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">الحسابات خلال 6 أشهر</h5>
                    </div>
                    <div class="card-body">
                        <div class="chart-container" style="height: 300px;">
                            <canvas id="monthlyChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- تقرير تفصيلي -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">التقرير التفصيلي</h5>
                        <div class="btn-group">
                            <button class="btn btn-sm btn-outline-primary" onclick="exportReport('pdf')">
                                <i class="bi bi-file-pdf"></i> PDF
                            </button>
                            <button class="btn btn-sm btn-outline-success" onclick="exportReport('excel')">
                                <i class="bi bi-file-excel"></i> Excel
                            </button>
                            <button class="btn btn-sm btn-outline-secondary" onclick="printReport()">
                                <i class="bi bi-printer"></i> طباعة
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover" id="detailedReport">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>التاريخ</th>
                                        <th>نوع المنتج</th>
                                        <th>العنوان</th>
                                        <th>المتغيرات</th>
                                        <th>النتائج</th>
                                        <th>الإجراءات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($calculations as $calculation)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td>{{ $calculation->created_at->format('Y-m-d') }}</td>
                                            <td>
                                                <span class="badge bg-info">{{ $calculation->productType->name }}</span>
                                            </td>
                                            <td>{{ Str::limit($calculation->title, 30) }}</td>
                                            <td>
                                                @php
                                                    $variables = json_decode($calculation->input_variables, true);
                                                    $count = count($variables);
                                                @endphp
                                                <span class="badge bg-secondary">{{ $count }} متغير</span>
                                            </td>
                                            <td>
                                                @php
                                                    $results = json_decode($calculation->calculated_results, true);
                                                    $resultCount = count($results);
                                                @endphp
                                                <span class="badge bg-success">{{ $resultCount }} نتيجة</span>
                                            </td>
                                            <td>
                                                <a href="{{ route('calculations.show', $calculation->id) }}"
                                                    class="btn btn-sm btn-outline-primary">
                                                    <i class="bi bi-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        {{ $calculations->links() }}
                    </div>
                </div>
            </div>
        </div>

        <!-- تحليل الأنواع -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">تحليل حسب نوع المنتج</h5>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead>
                                    <tr class="table-primary">
                                        <th>نوع المنتج</th>
                                        <th>عدد الحسابات</th>
                                        <th>النسبة المئوية</th>
                                        <th>آخر حساب</th>
                                        <th>المتغيرات الأكثر استخداماً</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($typeAnalysis as $analysis)
                                        <tr>
                                            <td>
                                                <strong>{{ $analysis['name'] }}</strong>
                                            </td>
                                            <td>
                                                <span class="badge bg-primary">{{ $analysis['count'] }}</span>
                                            </td>
                                            <td>
                                                <div class="progress" style="height: 20px;">
                                                    <div class="progress-bar" role="progressbar"
                                                        style="width: {{ $analysis['percentage'] }}%">
                                                        {{ number_format($analysis['percentage'], 1) }}%
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                @if ($analysis['last_calculation'])
                                                    {{ $analysis['last_calculation']->created_at->format('Y-m-d') }}
                                                @else
                                                    -
                                                @endif
                                            </td>
                                            <td>
                                                @foreach ($analysis['common_variables'] as $var)
                                                    <span class="badge bg-secondary">{{ $var }}</span>
                                                @endforeach
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- منطقة الطباعة -->
    <div id="printReportArea" style="display: none;"></div>
@endsection

@push('styles')
    <style>
        .progress {
            background-color: #e9ecef;
            border-radius: 0.375rem;
        }

        .progress-bar {
            background-color: #0d6efd;
            border-radius: 0.375rem;
        }

        .chart-container {
            position: relative;
        }
    </style>
@endpush

@push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        // بيانات المخططات
        const productTypeData = @json($productTypeData);
        const monthlyData = @json($monthlyData);

        // مخطط توزيع أنواع المنتجات
        const productTypeCtx = document.getElementById('productTypeChart').getContext('2d');
        const productTypeChart = new Chart(productTypeCtx, {
            type: 'doughnut',
            data: {
                labels: productTypeData.labels,
                datasets: [{
                    data: productTypeData.data,
                    backgroundColor: [
                        '#0d6efd', '#198754', '#ffc107', '#dc3545',
                        '#6f42c1', '#20c997', '#fd7e14', '#6610f2'
                    ]
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'bottom',
                        rtl: true
                    }
                }
            }
        });

        // مخطط شهري
        const monthlyCtx = document.getElementById('monthlyChart').getContext('2d');
        const monthlyChart = new Chart(monthlyCtx, {
            type: 'bar',
            data: {
                labels: monthlyData.labels,
                datasets: [{
                    label: 'عدد الحسابات',
                    data: monthlyData.data,
                    backgroundColor: '#198754',
                    borderColor: '#146c43',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            stepSize: 1
                        }
                    }
                },
                plugins: {
                    legend: {
                        display: false
                    }
                }
            }
        });

        // تصفية التقارير
        function filterReports() {
            const formData = new FormData(document.getElementById('reportFilters'));
            const params = new URLSearchParams();

            for (const [key, value] of formData.entries()) {
                if (value) {
                    params.append(key, value);
                }
            }

            window.location.href = '{{ route('reports.index') }}?' + params.toString();
        }

        // تصدير التقرير
        function exportReport(format) {
            const params = new URLSearchParams(window.location.search);
            params.append('export', format);

            window.location.href = '{{ route('reports.export') }}?' + params.toString();
        }

        // طباعة التقرير
        function printReport() {
            const printContent = `
        <html>
        <head>
            <title>تقرير حسابات الألمنيوم</title>
            <style>
                body { font-family: Arial, sans-serif; direction: rtl; padding: 20px; }
                h1 { text-align: center; color: #2c3e50; }
                table { width: 100%; border-collapse: collapse; margin: 20px 0; }
                th, td { border: 1px solid #ddd; padding: 8px; text-align: center; }
                th { background-color: #f8f9fa; }
                .footer { text-align: center; margin-top: 30px; color: #666; }
            </style>
        </head>
        <body>
            <h1>تقرير حسابات الألمنيوم</h1>
            <p>تاريخ التقرير: ${new Date().toLocaleDateString('ar-SA')}</p>
            
            <h3>إحصائيات عامة:</h3>
            <table>
                <tr>
                    <th>إجمالي الحسابات</th>
                    <th>متوسط الحسابات/يوم</th>
                    <th>أكثر نوع استخداماً</th>
                    <th>حسابات هذا الشهر</th>
                </tr>
                <tr>
                    <td>${$('#totalCalculations').text()}</td>
                    <td>${$('#avgPerDay').text()}</td>
                    <td>${$('#mostUsedType').text()}</td>
                    <td>${$('#monthCalculations').text()}</td>
                </tr>
            </table>
            
            <h3>التقرير التفصيلي:</h3>
            ${document.getElementById('detailedReport').outerHTML}
            
            <div class="footer">
                <p>تم إنشاء هذا التقرير بواسطة نظام حساب الألمنيوم</p>
                <p>${new Date().toLocaleString('ar-SA')}</p>
            </div>
        </body>
        </html>
    `;

            const printWindow = window.open('', '_blank');
            printWindow.document.write(printContent);
            printWindow.document.close();
            printWindow.print();
        }

        // تحديث المخططات عند تغيير المرشحات
        document.getElementById('reportFilters').addEventListener('submit', function(e) {
            e.preventDefault();
            filterReports();
        });
    </script>
@endpush
