<!-- resources/views/calculations/create.blade.php -->


<?php $__env->startSection('title', 'حساب جديد'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <h2 class="mb-4">
                    <?php if($calculationToDuplicate): ?>
                        نسخ حساب: <?php echo e($calculationToDuplicate->title); ?>

                    <?php else: ?>
                        حساب مقاسات الألمنيوم
                    <?php endif; ?>
                </h2>
            </div>
        </div>

        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">إدخال البيانات</h5>
                    </div>
                    <div class="card-body">
                        <form id="calculationForm" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label for="title" class="form-label">عنوان الحساب</label>
                                    <input type="text" class="form-control" id="title" name="title"
                                        value="<?php echo e($calculationToDuplicate ? 'نسخة من ' . $calculationToDuplicate->title : 'حساب جديد'); ?>"
                                        required>
                                </div>
                                <div class="col-md-6">
                                    <label for="product_type_id" class="form-label">نوع المنتج</label>
                                    <select class="form-select" id="product_type_id" name="product_type_id" required>
                                        <option value="">اختر نوع المنتج</option>
                                        <?php $__currentLoopData = $productTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($type->id); ?>"
                                                <?php echo e($calculationToDuplicate && $calculationToDuplicate->product_type_id == $type->id ? 'selected' : ''); ?>>
                                                <?php echo e($type->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>

                            <div id="variablesSection" class="mb-3"
                                style="<?php echo e($calculationToDuplicate ? '' : 'display: none;'); ?>">
                                <h5 class="mb-3">المتغيرات المطلوبة</h5>
                                <div id="variablesContainer">
                                    <?php if($calculationToDuplicate): ?>
                                        <?php
                                            $variables = json_decode($calculationToDuplicate->input_variables, true);
                                        ?>
                                        <?php $__currentLoopData = $variables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="mb-2 variable-input-container">
                                                <label for="var_<?php echo e($key); ?>"
                                                    class="form-label"><?php echo e($key); ?></label>
                                                <div class="input-group">
                                                    <input type="number" class="form-control variable-input"
                                                        id="var_<?php echo e($key); ?>" name="variables[<?php echo e($key); ?>]"
                                                        value="<?php echo e($value); ?>" step="0.01" required>
                                                    <span class="input-group-text">mm</span>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div id="formulasPreview" class="mb-3"
                                style="<?php echo e($calculationToDuplicate ? '' : 'display: none;'); ?>">
                                <h5 class="mb-3">معاينة المعادلات</h5>
                                <div id="formulasList"></div>
                            </div>

                            <div class="mb-3">
                                <label for="notes" class="form-label">ملاحظات</label>
                                <textarea class="form-control" id="notes" name="notes" rows="3"><?php echo e($calculationToDuplicate->notes ?? ''); ?></textarea>
                            </div>

                            <button type="submit" class="btn btn-primary" id="calculateBtn">
                                <i class="bi bi-calculator"></i> حساب النتائج
                            </button>

                            <div id="debugInfo"
                                style="margin-top: 20px; padding: 10px; background: #f5f5f5; border-radius: 5px; display: none;">
                                <h6>معلومات التصحيح:</h6>
                                <pre id="debugOutput"></pre>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">المتغيرات المتاحة</h5>
                    </div>
                    <div class="card-body">
                        <div id="availableVariables">
                            <?php $__currentLoopData = ['الطول', 'العرض', 'الارتفاع', 'السماكة', 'العدد', 'الوزن', 'الكلفة']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variable): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span class="badge bg-secondary variable-badge mb-1 me-1"
                                    data-variable="<?php echo e($variable); ?>" style="cursor: pointer; padding: 8px;">
                                    <?php echo e($variable); ?>

                                </span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        <div class="mt-3">
                            <h6>إضافة متغير مخصص:</h6>
                            <div class="input-group">
                                <input type="text" class="form-control" id="customVariable" placeholder="اسم المتغير">
                                <button class="btn btn-outline-success" type="button" onclick="addCustomVariable()">
                                    <i class="bi bi-plus"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header">
                        <h5 class="card-title mb-0">النتائج</h5>
                    </div>
                    <div class="card-body">
                        <div id="resultsContainer">
                            <p class="text-muted">ستظهر النتائج هنا...</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        // أولاً: طباعة أن الصفحة قد تم تحميلها
        console.log('========== صفحة الحساب الجديد تم تحميلها ==========');
        console.log('الوقت:', new Date().toLocaleString());

        // طباعة معلومات CSRF Token
        console.log('CSRF Token موجود:', $('input[name="_token"]').length > 0);
        console.log('CSRF Token:', $('input[name="_token"]').val());

        // طباعة معلومات أنواع المنتجات
        console.log('عدد أنواع المنتجات:', <?php echo e(count($productTypes)); ?>);
        <?php $__currentLoopData = $productTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            console.log('- <?php echo e($type->name); ?> (ID: <?php echo e($type->id); ?>)');
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        $(document).ready(function() {
            console.log('========== jQuery جاهز ==========');

            let currentProductType = null;
            let formulas = [];

            // طباعة حالة نسخ الحساب
            <?php if($calculationToDuplicate): ?>
                console.log('جاري نسخ حساب موجود:', {
                    id: <?php echo e($calculationToDuplicate->id); ?>,
                    title: '<?php echo e($calculationToDuplicate->title); ?>',
                    product_type_id: <?php echo e($calculationToDuplicate->product_type_id); ?>,
                    variables: <?php echo json_encode(json_decode($calculationToDuplicate->input_variables, true), 512) ?>
                });
            <?php else: ?>
                console.log('حساب جديد (ليس نسخاً)');
            <?php endif; ?>

            // إذا كان هناك حساب للنسخ، قم بتحميل المعادلات
            <?php if($calculationToDuplicate): ?>
                console.log('جاري تحميل معادلات لنوع المنتج:', <?php echo e($calculationToDuplicate->product_type_id); ?>);
                loadFormulas(<?php echo e($calculationToDuplicate->product_type_id); ?>);
            <?php endif; ?>

            // تغيير نوع المنتج
            $('#product_type_id').change(function() {
                const productTypeId = $(this).val();
                console.log('تم تغيير نوع المنتج إلى:', productTypeId);

                if (!productTypeId) {
                    console.log('لم يتم اختيار نوع منتج - إخفاء الأقسام');
                    $('#variablesSection').hide();
                    $('#formulasPreview').hide();
                    return;
                }

                console.log('جاري تحميل المعادلات لنوع المنتج:', productTypeId);
                loadFormulas(productTypeId);
            });

            // تحميل المعادلات
            function loadFormulas(productTypeId) {
                console.log('جاري طلب المعادلات من:', '/formulas/product-type/' + productTypeId);

                $.ajax({
                    url: '/formulas/product-type/' + productTypeId,
                    method: 'GET',
                    success: function(response) {
                        console.log('✅ تم تحميل المعادلات بنجاح:', response);
                        formulas = response;
                        currentProductType = productTypeId;

                        console.log('عدد المعادلات المحملة:', formulas.length);
                        formulas.forEach((formula, index) => {
                            console.log(
                                `المعادلة ${index + 1}: ${formula.name} -> ${formula.formula}`
                                );
                        });

                        // إذا لم يكن هناك متغيرات محددة مسبقاً، عرض المتغيرات المطلوبة
                        <?php if(!$calculationToDuplicate): ?>
                            console.log('جاري عرض المتغيرات المطلوبة');
                            showRequiredVariables(formulas);
                        <?php endif; ?>

                        // عرض معاينة المعادلات
                        console.log('جاري عرض معاينة المعادلات');
                        showFormulasPreview(formulas);

                        $('#variablesSection').show();
                        $('#formulasPreview').show();
                        console.log('✅ تم عرض قسمي المتغيرات والمعادلات');
                    },
                    error: function(xhr, status, error) {
                        console.error('❌ فشل في تحميل المعادلات:', {
                            status: xhr.status,
                            statusText: xhr.statusText,
                            error: error,
                            responseText: xhr.responseText,
                            url: xhr.responseURL
                        });
                        alert('فشل في تحميل المعادلات. تحقق من الكونسول.');
                    }
                });
            }

            // إضافة متغير
            $(document).on('click', '.variable-badge', function() {
                const variable = $(this).data('variable');
                console.log('تم النقر على متغير:', variable);
                addVariableInput(variable);
            });

            // إضافة متغير مخصص
            window.addCustomVariable = function() {
                const customVar = $('#customVariable').val().trim();
                console.log('إضافة متغير مخصص:', customVar);
                if (customVar) {
                    addVariableInput(customVar);
                    $('#customVariable').val('');
                }
            };

            // حساب النتائج
            $('#calculationForm').submit(function(e) {
                e.preventDefault();
                console.log('========== تم الضغط على زر حساب النتائج ==========');

                // جمع المتغيرات
                const variables = {};
                console.log('جاري جمع المتغيرات من النموذج...');

                $('.variable-input').each(function(index) {
                    const name = $(this).attr('name');
                    const value = $(this).val();
                    console.log(`المتغير ${index + 1}: name="${name}", value="${value}"`);

                    if (name && value) {
                        // استخراج اسم المتغير من name attribute
                        const varName = name.replace('variables[', '').replace(']', '');
                        variables[varName] = parseFloat(value);
                    }
                });

                console.log('المتغيرات المجمعة:', variables);
                console.log('عدد المتغيرات:', Object.keys(variables).length);

                // التحقق من وجود متغيرات
                if (Object.keys(variables).length === 0) {
                    console.error('❌ لا توجد متغيرات مدخلة!');
                    alert('يرجى إدخال المتغيرات المطلوبة');
                    return;
                }

                // جمع بيانات النموذج
                const formData = {
                    product_type_id: $('#product_type_id').val(),
                    title: $('#title').val(),
                    variables: variables,
                    notes: $('#notes').val(),
                    _token: $('input[name="_token"]').val()
                };

                console.log('بيانات النموذج المرسلة:', formData);
                console.log('جاري إرسال البيانات إلى:', "<?php echo e(route('calculations.store')); ?>");

                // إظهار معلومات التصحيح في الصفحة
                $('#debugInfo').show();
                $('#debugOutput').text(JSON.stringify({
                    url: "<?php echo e(route('calculations.store')); ?>",
                    data: formData,
                    time: new Date().toLocaleTimeString()
                }, null, 2));

                // إظهار حالة التحميل
                $('#calculateBtn').prop('disabled', true).html(
                    '<span class="spinner-border spinner-border-sm"></span> جاري الحساب...');

                // استخدام fetch للتحكم الكامل
                fetch("<?php echo e(route('calculations.store')); ?>", {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': $('input[name="_token"]').val(),
                            'X-Requested-With': 'XMLHttpRequest'
                        },
                        body: JSON.stringify(formData)
                    })
                    .then(response => {
                        console.log('✅ تم استلام الرد من الخادم');
                        console.log('Status:', response.status);
                        console.log('Status Text:', response.statusText);
                        console.log('Headers:', Object.fromEntries(response.headers.entries()));

                        return response.text().then(text => {
                            console.log('Raw Response:', text);
                            try {
                                return JSON.parse(text);
                            } catch (e) {
                                console.error('❌ فشل في تحويل الرد إلى JSON:', e);
                                return {
                                    error: 'Invalid JSON response',
                                    raw: text
                                };
                            }
                        });
                    })
                    .then(data => {
                        console.log('✅ بيانات الرد:', data);

                        $('#calculateBtn').prop('disabled', false).html(
                            '<i class="bi bi-calculator"></i> حساب النتائج');

                        if (data.success) {
                            console.log('✅ الحساب ناجح!');
                            console.log('النتائج:', data.calculation.calculated_results);
                            console.log('التوجيه إلى:', data.redirect);

                            // عرض النتائج
                            showResults(data.calculation.calculated_results);

                            // التوجيه بعد 2 ثانية
                            setTimeout(function() {
                                console.log('جاري التوجيه إلى صفحة النتائج...');
                                window.location.href = data.redirect;
                            }, 2000);
                        } else if (data.errors) {
                            console.error('❌ أخطاء تحقق:', data.errors);
                            alert('أخطاء في البيانات: ' + JSON.stringify(data.errors));
                        } else {
                            console.error('❌ خطأ غير معروف:', data);
                            alert('حدث خطأ غير معروف: ' + JSON.stringify(data));
                        }
                    })
                    .catch(error => {
                        console.error('❌ خطأ في الاتصال:', error);
                        $('#calculateBtn').prop('disabled', false).html(
                            '<i class="bi bi-calculator"></i> حساب النتائج');
                        alert('فشل الاتصال بالخادم: ' + error.message);
                    });
            });

            function showRequiredVariables(formulasList) {
                console.log('جاري استخراج المتغيرات المطلوبة من المعادلات...');
                const container = $('#variablesContainer');
                <?php if(!$calculationToDuplicate): ?>
                    console.log('تفريغ حاوية المتغيرات...');
                    container.empty();
                <?php endif; ?>

                const requiredVars = new Set();
                formulasList.forEach(formula => {
                    console.log(`تحليل المعادلة: ${formula.formula}`);
                    const matches = formula.formula.match(/{(\w+)}/g);
                    if (matches) {
                        matches.forEach(match => {
                            const varName = match.replace(/[{}]/g, '');
                            console.log(`- وجد متغير: ${varName}`);
                            requiredVars.add(varName);
                        });
                    }
                });

                console.log('المتغيرات المطلوبة:', Array.from(requiredVars));

                requiredVars.forEach(variable => {
                    // تحقق مما إذا كان المتغير موجوداً بالفعل
                    const inputId = 'var_' + variable.replace(/\s+/g, '_');
                    if (!$('#' + inputId).length) {
                        console.log(`إضافة حقل إدخال للمتغير: ${variable}`);
                        addVariableInput(variable);
                    } else {
                        console.log(`المتغير ${variable} موجود بالفعل`);
                    }
                });
            }

            function addVariableInput(variableName) {
                console.log(`إنشاء حقل إدخال للمتغير: ${variableName}`);
                const container = $('#variablesContainer');
                const inputId = 'var_' + variableName.replace(/\s+/g, '_');

                // تحقق من عدم وجود المتغير بالفعل
                if ($('#' + inputId).length) {
                    console.log(`المتغير ${variableName} موجود بالفعل، تخطي...`);
                    return;
                }

                const inputHtml = `
            <div class="mb-2 variable-input-container">
                <label for="${inputId}" class="form-label">${variableName}</label>
                <div class="input-group">
                    <input type="number" 
                           class="form-control variable-input" 
                           id="${inputId}" 
                           name="variables[${variableName}]" 
                           step="0.01"
                           placeholder="أدخل قيمة ${variableName}"
                           required>
                    <span class="input-group-text">mm</span>
                </div>
            </div>
        `;

                console.log(`إضافة HTML للمتغير ${variableName}`);
                container.append(inputHtml);
                console.log(`✅ تمت إضافة حقل ${variableName}`);
            }

            function showFormulasPreview(formulasList) {
                console.log('جاري عرض معاينة المعادلات...');
                const container = $('#formulasList');
                container.empty();

                formulasList.forEach((formula, index) => {
                    console.log(`إضافة معادلة ${index + 1}: ${formula.name}`);
                    const formulaHtml = `
                <div class="alert alert-light mb-2">
                    <h6 class="mb-1">${formula.name}</h6>
                    <code class="d-block mb-1">${formula.formula}</code>
                    <small class="text-muted">الوحدة: ${formula.unit}</small>
                </div>
            `;
                    container.append(formulaHtml);
                });
                console.log('✅ تم عرض معاينة المعادلات');
            }

            function showResults(results) {
                console.log('جاري عرض النتائج...');
                const container = $('#resultsContainer');
                container.empty();

                // إضافة رسالة نجاح
                const successHtml = `
            <div class="alert alert-success">
                <h5><i class="bi bi-check-circle"></i> تم الحساب بنجاح!</h5>
                <p class="mb-0">يتم التوجيه إلى صفحة النتائج...</p>
            </div>
        `;
                container.append(successHtml);
                console.log('✅ تمت إضافة رسالة النجاح');

                // إضافة النتائج
                for (const [key, value] of Object.entries(results)) {
                    console.log(`إضافة نتيجة: ${value.name} = ${value.value} ${value.unit}`);
                    const resultHtml = `
                <div class="alert alert-info mt-2">
                    <h6 class="mb-1">${value.name}</h6>
                    <p class="mb-1"><strong>النتيجة:</strong> ${value.value} ${value.unit}</p>
                    <small class="text-muted d-block">${value.formula}</small>
                </div>
            `;
                    container.append(resultHtml);
                }
                console.log('✅ تم عرض جميع النتائج');
            }

            // اختبار الاتصال عند التحميل
            console.log('جاري اختبار الاتصال بالخادم...');
            $.ajax({
                url: '/',
                method: 'GET',
                success: function() {
                    console.log('✅ الاتصال بالخادم يعمل بشكل جيد');
                },
                error: function(xhr) {
                    console.error('❌ مشكلة في الاتصال بالخادم:', xhr.status, xhr.statusText);
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\خالي رفيق\aluminum-factory\resources\views/calculations/create.blade.php ENDPATH**/ ?>