<!-- resources/views/formulas/index.blade.php -->


<?php $__env->startSection('title', 'إدارة المعادلات'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <h2 class="mb-4">إدارة المعادلات</h2>
            </div>
        </div>

        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">قائمة المعادلات</h5>
                        <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#addFormulaModal">
                            <i class="bi bi-plus"></i> إضافة معادلة
                        </button>
                    </div>
                    <div class="card-body">
                        <?php if($formulas->count() > 0): ?>
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>اسم المعادلة</th>
                                            <th>نوع المنتج</th>
                                            <th>المعادلة</th>
                                            <th>الحالة</th>
                                            <th>الإجراءات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $formulas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $formula): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($loop->iteration); ?></td>
                                                <td><?php echo e($formula->name); ?></td>
                                                <td><?php echo e($formula->productType->name); ?></td>
                                                <td><code><?php echo e($formula->formula); ?></code></td>
                                                <td>
                                                    <?php if($formula->is_active): ?>
                                                        <span class="badge bg-success">نشط</span>
                                                    <?php else: ?>
                                                        <span class="badge bg-danger">غير نشط</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <button class="btn btn-sm btn-warning" data-bs-toggle="modal"
                                                        data-bs-target="#editFormulaModal" data-id="<?php echo e($formula->id); ?>"
                                                        data-name="<?php echo e($formula->name); ?>"
                                                        data-product_type_id="<?php echo e($formula->product_type_id); ?>"
                                                        data-variable_name="<?php echo e($formula->variable_name); ?>"
                                                        data-formula="<?php echo e($formula->formula); ?>"
                                                        data-unit="<?php echo e($formula->unit); ?>" data-order="<?php echo e($formula->order); ?>"
                                                        data-is_active="<?php echo e($formula->is_active); ?>">
                                                        <i class="bi bi-pencil"></i>
                                                    </button>
                                                    <form action="<?php echo e(route('formulas.destroy', $formula->id)); ?>"
                                                        method="POST" class="d-inline">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" class="btn btn-sm btn-danger"
                                                            onclick="return confirm('هل أنت متأكد؟')">
                                                            <i class="bi bi-trash"></i>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-info">
                                لا توجد معادلات مضافة بعد.
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">إضافة معادلة جديدة</h5>
                    </div>
                    <div class="card-body">
                        <form id="addFormulaForm">
                            <?php echo csrf_field(); ?>
                            <div class="mb-3">
                                <label for="product_type_id" class="form-label">نوع المنتج</label>
                                <select class="form-select" id="product_type_id" name="product_type_id" required>
                                    <option value="">اختر نوع المنتج</option>
                                    <?php $__currentLoopData = $productTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($type->id); ?>"><?php echo e($type->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="mb-3">
                                <label for="name" class="form-label">اسم المعادلة</label>
                                <input type="text" class="form-control" id="name" name="name" required>
                                <small class="text-muted">مثال: حلق علوي، حلق سفلي</small>
                            </div>

                            <div class="mb-3">
                                <label for="variable_name" class="form-label">اسم المتغير الناتج</label>
                                <input type="text" class="form-control" id="variable_name" name="variable_name" required>
                                <small class="text-muted">الاسم الذي سيظهر للنتيجة</small>
                            </div>

                            <div class="mb-3">
                                <label for="formula" class="form-label">المعادلة الرياضية</label>
                                <div class="input-group">
                                    <input type="text" class="form-control" id="formula" name="formula" required>
                                    <button type="button" class="btn btn-outline-secondary" onclick="showVariablesModal()">
                                        <i class="bi bi-code-slash"></i>
                                    </button>
                                </div>
                                <small class="text-muted">استخدم المتغيرات بين الأقواس {مثل} {الطول} * 2</small>
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label for="unit" class="form-label">الوحدة</label>
                                    <input type="text" class="form-control" id="unit" name="unit" value="mm"
                                        required>
                                </div>
                                <div class="col-md-6">
                                    <label for="order" class="form-label">الترتيب</label>
                                    <input type="number" class="form-control" id="order" name="order" value="0">
                                </div>
                            </div>

                            <div class="mb-3 form-check">
                                <input type="checkbox" class="form-check-input" id="is_active" name="is_active"
                                    value="1" checked>
                                <label class="form-check-label" for="is_active">نشط</label>
                            </div>

                            <button type="submit" class="btn btn-primary w-100">إضافة المعادلة</button>
                        </form>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header">
                        <h5 class="card-title mb-0">المتغيرات المتاحة</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-2">
                            <h6>المتغيرات الأساسية:</h6>
                            <div>
                                <?php $__currentLoopData = ['الطول', 'العرض', 'الارتفاع', 'السماكة', 'العدد']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variable): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <button type="button" class="btn btn-sm btn-outline-primary mb-1"
                                        onclick="insertVariable('<?php echo e($variable); ?>')">
                                        <?php echo e($variable); ?>

                                    </button>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <div class="mb-2">
                            <h6>العمليات الرياضية:</h6>
                            <div>
                                <button type="button" class="btn btn-sm btn-outline-secondary mb-1"
                                    onclick="insertOperator('+')">+</button>
                                <button type="button" class="btn btn-sm btn-outline-secondary mb-1"
                                    onclick="insertOperator('-')">-</button>
                                <button type="button" class="btn btn-sm btn-outline-secondary mb-1"
                                    onclick="insertOperator('*')">×</button>
                                <button type="button" class="btn btn-sm btn-outline-secondary mb-1"
                                    onclick="insertOperator('/')">÷</button>
                                <button type="button" class="btn btn-sm btn-outline-secondary mb-1"
                                    onclick="insertOperator('(')">(</button>
                                <button type="button" class="btn btn-sm btn-outline-secondary mb-1"
                                    onclick="insertOperator(')')">)</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal تعديل المعادلة -->
    <div class="modal fade" id="editFormulaModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">تعديل المعادلة</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="editFormulaForm" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="modal-body">
                        <input type="hidden" id="edit_id" name="id">

                        <div class="mb-3">
                            <label for="edit_name" class="form-label">اسم المعادلة</label>
                            <input type="text" class="form-control" id="edit_name" name="name" required>
                        </div>

                        <div class="mb-3">
                            <label for="edit_variable_name" class="form-label">اسم المتغير الناتج</label>
                            <input type="text" class="form-control" id="edit_variable_name" name="variable_name"
                                required>
                        </div>

                        <div class="mb-3">
                            <label for="edit_formula" class="form-label">المعادلة الرياضية</label>
                            <input type="text" class="form-control" id="edit_formula" name="formula" required>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="edit_unit" class="form-label">الوحدة</label>
                                <input type="text" class="form-control" id="edit_unit" name="unit" required>
                            </div>
                            <div class="col-md-6">
                                <label for="edit_order" class="form-label">الترتيب</label>
                                <input type="number" class="form-control" id="edit_order" name="order">
                            </div>
                        </div>

                        <div class="mb-3 form-check">
                            <input type="checkbox" class="form-check-input" id="edit_is_active" name="is_active"
                                value="1">
                            <label class="form-check-label" for="edit_is_active">نشط</label>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                        <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal المتغيرات -->
    <div class="modal fade" id="variablesModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">إدراج متغير</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <?php $__currentLoopData = ['الطول', 'العرض', 'الارتفاع', 'السماكة', 'العدد']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variable): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-6 mb-2">
                                <button type="button" class="btn btn-outline-primary w-100"
                                    onclick="insertVariableToField('<?php echo e($variable); ?>')">
                                    <?php echo e($variable); ?>

                                </button>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        // إضافة معادلة جديدة
        $('#addFormulaForm').submit(function(e) {
            e.preventDefault();

            const formData = $(this).serialize();

            $.ajax({
                url: '<?php echo e(route('formulas.store')); ?>',
                method: 'POST',
                data: formData,
                success: function(response) {
                    location.reload();
                },
                error: function(xhr) {
                    if (xhr.status === 422) {
                        const errors = xhr.responseJSON.errors;
                        alert('يرجى تصحيح الأخطاء: ' + JSON.stringify(errors));
                    }
                }
            });
        });

        // تعديل معادلة
        $('#editFormulaModal').on('show.bs.modal', function(event) {
            const button = $(event.relatedTarget);
            const formulaId = button.data('id');

            $('#edit_id').val(formulaId);
            $('#edit_name').val(button.data('name'));
            $('#edit_variable_name').val(button.data('variable_name'));
            $('#edit_formula').val(button.data('formula'));
            $('#edit_unit').val(button.data('unit'));
            $('#edit_order').val(button.data('order'));
            $('#edit_is_active').prop('checked', button.data('is_active') == 1);

            $('#editFormulaForm').attr('action', '/formulas/' + formulaId);
        });

        // إدراج متغير
        function insertVariable(variable) {
            const formulaField = $('#formula');
            const currentValue = formulaField.val();
            formulaField.val(currentValue + '{' + variable + '}');
        }

        function insertOperator(operator) {
            const formulaField = $('#formula');
            const currentValue = formulaField.val();
            formulaField.val(currentValue + operator);
        }

        function showVariablesModal() {
            $('#variablesModal').modal('show');
        }

        function insertVariableToField(variable) {
            const activeField = document.activeElement;
            if (activeField && (activeField.id === 'formula' || activeField.id === 'edit_formula')) {
                const start = activeField.selectionStart;
                const end = activeField.selectionEnd;
                const text = activeField.value;
                activeField.value = text.substring(0, start) + '{' + variable + '}' + text.substring(end);
                activeField.focus();
                activeField.setSelectionRange(start + variable.length + 2, start + variable.length + 2);
            }
            $('#variablesModal').modal('hide');
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\خالي رفيق\aluminum-factory\resources\views/formulas/index.blade.php ENDPATH**/ ?>